// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : input.h
// Date           : February 2008
//
// Description    : This file defines the CInput class used to handle all mouse
//                  and keyboard input via DirectInput.
//
//                  Init() must be called at the beginning of the main program
//                  to ensure the keyboard and mouse inputs are setup properly.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once


#include <windows.h>

#include "global.h"



class Input 
{

  protected:

    int                     m_keyCurrState[256];
    int                     m_keyPrevState[256];
    bool                    m_anyKeyPressed;
    int                     m_MouseButtons;
    int                     m_MousePrevButtons;

    int                     m_mouseX;
    int                     m_mouseY;


  public:

    Input();
    ~Input();


    void                    Init( HWND hWnd );
    void                    Release();

    void                    Update();
    bool                    KeyPressed( int key );
    bool                    KeyDown( int key );
    bool                    AnyKeyPressed();
    bool                    MouseButtonPressed( int button );
    bool                    MouseButtonDown( int button );

    int                     MouseX();
    int                     MouseY();

    void                    UpdateMouse( int Buttons, int X, int Y );

    void                    KeyIsDown( int Key );
    void                    KeyIsUp( int Key );

};


